uniform sampler2D texTo;
uniform sampler2D texFrom;
uniform sampler2D texCloud;

uniform float crossfader;
uniform float randomSeed;
uniform float levelFrom;
uniform float levelTo;

void main()
{
	vec2 uv = gl_TexCoord[0].st;
  vec4 color = gl_Color;

	float radius = crossfader * 0.70710678;
	vec2 fromCenter = uv.xy - vec2(0.5, 0.5);
  float len = length(fromCenter);
	vec2 toUV = normalize(fromCenter);
	float angle = (atan(toUV.x, toUV.y) + 3.141592) / (2.0 * 3.141592);
	radius += crossfader * texture2D(texCloud, vec2(angle, fract(randomSeed + crossfader / 5.0))).r;

	if (len < radius)
	{
		color=texture2D(texTo, uv);
    color.a=levelTo;
	}
	else
	{
		color=texture2D(texFrom, uv);
    color.a=levelFrom;
  }

	gl_FragColor = color;
}